(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     39827,       1065]*)
(*NotebookOutlinePosition[     40527,       1089]*)
(*  CellTagsIndexPosition[     40483,       1085]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Pr\[AAcute]ctica 3. Soluciones", "Title"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell["\<\
Supongamos una poblaci\[OAcute]n de peces que, en condiciones naturales, \
responde al modelo log\[IAcute]stico, est\[AAcute] siendo pescada de forma \
proporcional al n\[UAcute]mero de peces que la forman. Es decir, cuanto m\
\[AAcute]s abunda la pesca se pescan m\[AAcute]s. Esto lleva a la ED aut\
\[OAcute]noma siguiente.\
\>", "ExerciseText"],

Cell[BoxData[
    \(TraditionalForm\`y' \((t)\) = 
      r\ \(y(t)\) \((1 - \ \(y(t)\)\/K)\) - m\ \(y(t)\)\)], "NumberedEquation",\

  TextAlignment->Center,
  FormatType->StandardForm],

Cell[TextData[{
  "Donde, ",
  Cell[BoxData[
      \(TraditionalForm\`r, \ K, \ m\)]],
  " son constantes positivas. El t\[EAcute]rmino ",
  Cell[BoxData[
      \(TraditionalForm\`m\ \(y(t)\)\)]],
  " es el n\[UAcute]mero de peces pescados por unidad de tiempo.\na) Calcula, \
con la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (sin usar el comando DSolve[ ]) la soluci\[OAcute]n de la ED (1) que \
verifica ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = p\)]],
  ". Sugerencia. Usa FullSimplify[ ] para simplificar.\nb) Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`r = 8/100, \ k = 1000, \ m = 1/100\)]],
  " representa algunas curvas soluci\[OAcute]n para distintos valores de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ".\nc) Prueba que si ",
  Cell[BoxData[
      \(TraditionalForm\`m < r\)]],
  ", entonces hay dos puntos de equilibrio, ",
  Cell[BoxData[
      \(TraditionalForm\`y\_1 = 0\)]],
  ", e ",
  Cell[BoxData[
      \(TraditionalForm\`y\_2 = K(1 - m/r) > 0\)]],
  ". Justifica que ",
  Cell[BoxData[
      \(TraditionalForm\`y\_1\)]],
  " es inestable e ",
  Cell[BoxData[
      \(TraditionalForm\`y\_2\)]],
  " es asint\[OAcute]ticamente estable.\nd) La cantidad ",
  Cell[BoxData[
      \(TraditionalForm\`m\ y\_2\)]],
  " es el n\[UAcute]mero de peces que a largo plazo podr\[AAcute] pescarse. \
Calcula el valor de ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " que hace m\[AAcute]xima esta cantidad. "
}], "ExerciseText"],

Cell[BoxData[
    \(Collect[r\ y \((1 - y/k)\) - m\ y, y]\)], "Input"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\n", 
    \(sol[t_] = 
      y /. \(Solve[Integrate[1\/\(\((r - m)\) y - r\/k*y\^2\), y] == t + c, 
              y]\)[\([1]\)] // Simplify\), "\[IndentingNewLine]", 
    \(\(c /. \(Solve[sol[0] \[Equal] p, c]\)[\([1]\)];\)\), "\n", 
    \(\(sol[t] /. c \[Rule] % // Simplify;\)\), "\[IndentingNewLine]", 
    \(\(y[r_, k_, m_, p_]\)[t_] = 
      FullSimplify[%, r > 0 && p > 0 && m > 0 && k > 0]\)}], "Input"],

Cell[BoxData[{
    \(\(y /. 
        Solve[\((r - m)\) y - r\/k*y\^2 \[Equal] 0, 
          y];\)\), "\[IndentingNewLine]", 
    \(soleq[r_, k_, m_] = Simplify[%]\)}], "Input"],

Cell[BoxData[
    \(Limit[\(y[r, k, m, p]\)[t], t \[Rule] \(+\[Infinity]\), 
      Assumptions \[Rule] m < r]\)], "Input"],

Cell[BoxData[
    \(\(Plot[\(y[ .8, 1000,  .01, 200]\)[t], {t, 0, 10}];\)\)], "Input"],

Cell[BoxData[
    \(soleq[8/100, 1000, 1/100]\)], "Input"],

Cell[BoxData[{
    \(\(h[m_] = m \((k - k\ m/r)\);\)\), "\[IndentingNewLine]", 
    \(m /. \(Solve[\(h'\)[m] \[Equal] 0, 
          m]\)[\([1]\)]\), "\[IndentingNewLine]", 
    \(h[%]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[BoxData[{
    FormBox[\(Considera\ la\ ED\ aut\[OAcute]noma\), TraditionalForm], "\n", 
    FormBox[
      RowBox[{"\t\t\t\t\t", 
        FormBox[\(\[DifferentialD]y\/\[DifferentialD]t = \((r - s)\) y - 
              a\ y\^3\),
          "TraditionalForm"]}], TraditionalForm], "\[IndentingNewLine]", 
    FormBox[
      RowBox[{"donde", " ", Cell[TextData[Cell[BoxData[
            \(TraditionalForm\`\(\(r\)\(,\)\(\ \)\(s\)\(,\)\(\ \)\(a\)\(\ \
\)\)\)]]]], "son", " ", "constantes", " ", \(\(positivas\)\(.\)\(\ \)\)}], 
      TraditionalForm]}], "NumberedEquation"],

Cell[TextData[{
  "a) Calcula, con la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  (sin usar el comando DSolve[ ]) la soluci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(y[r, s, a, p]\)[t]\)\(\ \)\)\)]],
  " de la ED (2) que verifica ",
  Cell[BoxData[
      \(TraditionalForm\`y \((0)\) = p\)]],
  ". Sugerencia. Usa FullSimplify[ ] para simplificar. Adem\[AAcute]s debes \
simplificar tambi\[EAcute]n las ra\[IAcute]ces del denominador. Puedes usar \
para ello una regla como \n\t\tSimplify",
  Cell[BoxData[
      FormBox[
        RowBox[{"[", 
          RowBox[{
            FormBox[
              RowBox[{"%", " ", "/.", 
                FormBox[\(\((1/\((\@x_*\@y_)\))\) \[Rule] \ 1/\@\(x*y\)\),
                  "TraditionalForm"]}],
              "TraditionalForm"], ",", 
            " ", \(a > 0 && r > 0 && s > 0 && p > 0\)}], "]"}], 
        TraditionalForm]]],
  "\nb) Calcula las soluciones de equilibrio seg\[UAcute]n sea ",
  Cell[BoxData[
      \(TraditionalForm\`r < s\)]],
  " o ",
  Cell[BoxData[
      \(TraditionalForm\`r > s\)]],
  ". Comprueba que se trata efectivamente de soluciones de equilibrio.\nc) \
Calcula el l\[IAcute]mite de la soluci\[OAcute]n obtenida en el apartado a) \
para ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Rule] \(+\[Infinity]\)\)]],
  ". Debes considerar los casos ",
  Cell[BoxData[
      \(TraditionalForm\`r < s\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`r > s\)]],
  " con ",
  Cell[BoxData[
      \(TraditionalForm\`p > 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`r > s\)]],
  " con ",
  Cell[BoxData[
      \(TraditionalForm\`p > 0\)]],
  ". Debes simplificar los resultados obtenidos pues deben ser igual a los \
puntos de equilibrio. Sugerencia. Usa el comando Limit[ ] con \
\"Assumptions\". \nd) Representa en una misma gr\[AAcute]fica las \
gr\[AAcute]ficas de las soluciones ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(y[5, 1, 1, p]\)[t]\)\(\ \)\)\)]],
  " en el intervalo [0,1] para valores de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " desde ",
  Cell[BoxData[
      \(TraditionalForm\`p = \(-5.5\)\)]],
  " hasta ",
  Cell[BoxData[
      \(TraditionalForm\`p = 5.5\)]],
  " con incrementos de 0.5. Representa tambi\[EAcute]n en la misma \
gr\[AAcute]fica con Epilog\[Rule]{Thickness[.007], Line[ ], Line[ ]} las \
soluciones de equilibrio ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(-2\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y = 2\)]],
  ". Debes usar PlotRange\[Rule]{-5.5,5.5}, AspectRatio\[Rule]1 y con \
PlotStyle representas las gr\[AAcute]ficas para valores negativos de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " en azul, para valores positivos de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " en verde y para ",
  Cell[BoxData[
      \(TraditionalForm\`p = 0\)]],
  " en rojo (un comando Which[ ] puede ser \[UAcute]til). Usa DisplayFunction\
\[Rule]Identity para no generar nada m\[AAcute]s que la gr\[AAcute]fica \
final. \ne) Comenta la naturaleza de las soluciones de equilibrio."
}], "ExerciseText"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\n", 
    \(sol[t_] = 
      x /. \(Solve[Integrate[1\/\(\((a - x)\) \((b - x)\)\), x] == t + c, 
              x]\)[\([1]\)] // Simplify\), "\[IndentingNewLine]", 
    \(\(c /. \(Solve[sol[0] \[Equal] 0, c]\)[\([1]\)];\)\), "\n", 
    \(\(sol[t] /. c \[Rule] % // Simplify;\)\), "\[IndentingNewLine]", 
    \(\(y[a_, b_]\)[t_] = FullSimplify[%, a > 0 && b > 0]\)}], "Input"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\n", 
    \(sol[t_] = 
      x /. \(Solve[Integrate[1\/\(\((r - s)\) x - \ a\ x^3\), x] == t + c, 
              x]\)[\([1]\)] // Simplify\), "\[IndentingNewLine]", 
    \(\(c /. \(Solve[sol[0] \[Equal] p, c]\)[\([1]\)];\)\), "\n", 
    \(\(sol[t] /. c \[Rule] % // Simplify;\)\), "\[IndentingNewLine]", 
    \(\(y[r_, s_, a_, p_]\)[t_] = 
      FullSimplify[%, r > 0 && s > 0 && a > 0 && p > 0]\)}], "Input"],

Cell[BoxData[
    \(\(y[r_, s_, a_, p_]\)[t_] = 
      Simplify[%5 /. \((1/\((\@x_*\@y_)\))\) \[Rule] \((1/\@\(x*y\))\), 
        r > 0 && s > 0 && a > 0 && p > 0]\)], "Input"],

Cell[BoxData[
    \(x /. Solve[\((r - s)\) x - \ a\ x^3 \[Equal] 0, x]\)], "Input"],

Cell[BoxData[
    \(Simplify[%, a > 0 && \(-r\) + s < 0]\)], "Input"],

Cell[BoxData[
    \(Simplify[\(y[r, s, a, \(-\@\(\(r - s\)\/a\)\)]\)[t], 
      t > 0 && r > 0 && s > 0 && a > 0 && r > s]\)], "Input"],

Cell[BoxData[
    \(Simplify[\(y[r, s, a, \@\(\(r - s\)\/a\)]\)[t], 
      t > 0 && r > 0 && s > 0 && a > 0 && r > s]\)], "Input"],

Cell[BoxData[
    \(Limit[\(y[r, s, a, p]\)[t], t \[Rule] \(+\[Infinity]\), 
      Assumptions -> r > 0 && s > 0 && a > 0 && p > 0 && r < s]\)], "Input"],

Cell[BoxData[
    \(Limit[\(y[r, s, a, p]\)[t], t \[Rule] \(+\[Infinity]\), 
      Assumptions -> r > 0 && s > 0 && a > 0 && p > 0 && r > s]\)], "Input"],

Cell[BoxData[
    \(Limit[\(y[r, s, a, p]\)[t], t \[Rule] \(+\[Infinity]\), 
      Assumptions -> r > 0 && s > 0 && a > 0 && p < 0 && r > s]\)], "Input"],

Cell[BoxData[{
    \(r = 5; s = 1; a = 1;\), "\[IndentingNewLine]", 
    \(\(y[r, s, a, p]\)[t]\)}], "Input"],

Cell[BoxData[
    \(\(Show[
        Table[Plot[\(y[r, s, a, p]\)[t], {t, 0, 1}, 
            PlotRange \[Rule] {\(-5.5\), 5.5}, AspectRatio \[Rule] 1, 
            PlotStyle \[Rule] 
              Which[p < 0, Hue[ .7], p \[Equal] 0.0, Hue[0], p > 0, 
                Hue[ .3]], DisplayFunction \[Rule] Identity, 
            Epilog \[Rule] {Thickness[ .007], Line[{{0, 2}, {1, 2}}], 
                Line[{{0, \(-2\)}, {1, \(-2\)}}]}], {p, \(-5.5\), 5.5,  .5}], 
        DisplayFunction \[Rule] $DisplayFunction];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Consideremos una reacci\[OAcute]n qu\[IAcute]mica en la que dos reactivos \
A y B, con concentraciones iniciales respectivas ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " moles por litro, siendo ",
  Cell[BoxData[
      \(TraditionalForm\`a < b\)]],
  ", reaccionan para formar con cada mol\[EAcute]cula de cada uno de ellos \
una mol\[EAcute]cula de una sustancia C. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(x(t)\)\(\ \)\)\)]],
  "la concentraci\[OAcute]n (en moles por litro) de la sustancia C en el \
tiempo ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". La ley de acci\[OAcute]n de masas afirma que, en estas  condiciones, la \
velocidad de reacci\[OAcute]n, es decir, la variaci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`x(t)\)]],
  " por unidad de tiempo, es proporcional en todo momento al producto de las \
concentraciones de las sustancias A y B: \n\t\t\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`x' \((t)\) = r\ \((a - x)\) \((b - x)\)\)]],
  "\na) Suponiendo que ",
  Cell[BoxData[
      \(TraditionalForm\`x(0) = 0\)]],
  ", justifica, sin resolver la ED, que ",
  Cell[BoxData[
      \(TraditionalForm\`lim\_\(t \[Rule] \(+\[Infinity]\)\)x(t) = a\)]],
  ".\nb) Calcula, con ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (sin usar el comando DSolve[ ]) la soluci\[OAcute]n de la ED que verifica \
",
  Cell[BoxData[
      \(TraditionalForm\`x(0) = 0\)]],
  ". Sugerencia. Usa FullSimplify[ ] para simplificar.\n"
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Poligonales de Euler", "Section"],

Cell[TextData[{
  "Consideremos una ED de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`y' = f(x, y)\)]],
  ". Podemos representar gr\[AAcute]ficamente las curvas integrales de esta \
ED sin m\[AAcute]s que tener en cuenta que la pendiente en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " de una curva integral que pase por  dicho punto tiene que ser igual a ",
  Cell[BoxData[
      \(TraditionalForm\`f(a, b)\)]],
  ". Por tanto, podemos aproximar la gr\[AAcute]fica de dicha curva por una \
poligonal, llamada una poligonal de Euler, cuyos v\[EAcute]rtices vienen \
dados por"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\(\((x\_1, y\_1)\) = \((a, b)\);\)\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\((x\_2, y\_2)\) = \((a, b)\) + 
          h\ \((1, f(a, b))\)\/\(\(||\)\((1, f(a, b))\)\(||\)\); \ \((x\_3, 
          y\_3)\) = \((x\_2, y\_2)\) + 
          h \(\(\ \)\((1, f(x\_2, y\_2))\)\)\/\(\(||\)\((1, f(x\_2, \
y\_2))\)\(||\)\)\)\(,\)\(\(.\)\(\ \)\(.\)\(\ \)\(.\)\)\(,\)\(\ \)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\((x\_\(n + 1\), 
          y\_\(n + 1\))\) = \((x\_n, y\_n)\) + 
          h\ \((1, f(x\_n, y\_n))\)\/\(\(||\)\((1, f(x\_n, y\_n))\)\(||\)\)\)\
\)\)]],
  ", . . ."
}], "Text"],

Cell[TextData[{
  "Es decir, nos desplazamos de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " al siguiente siguiendo la direcci\[OAcute]n del vector tangente  \
calculado en dicho punto y normalizado, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\(\((1, 
                f(x, y))\)\(\ \)\)\/\(\(||\)\((1, f(x, y))\)\(||\)\)\), ",", 
          " ", 
          RowBox[{Cell["y"], "avanzand"}]}], TraditionalForm]]],
  "o una distancia igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(h\)\(|\)\)\)]],
  " (",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", Cell[TextData[Cell[BoxData[
              \(TraditionalForm\`h\)]]]]}], TraditionalForm]]],
  " puede ser una cantidad positiva o negativa). Naturalmente, es de esperar \
que cuanto m\[AAcute]s peque\[NTilde]o sea el n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " mejor ser\[AAcute] la aproximaci\[OAcute]n obtenida. L\[OAcute]gicamente, \
la gr\[AAcute]fica debe representarse en alg\[UAcute]n intervalo que contenga \
al punto ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", digamos ",
  Cell[BoxData[
      \(TraditionalForm\`\([c, d]\)\)]],
  " con ",
  Cell[BoxData[
      \(TraditionalForm\`c \[LessEqual] a \[LessEqual] d\)]],
  ". La forma de proceder ser\[AAcute] calcular la poligonal a partir del \
punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " hasta llegar al valor de abscisa ",
  Cell[BoxData[
      \(TraditionalForm\`x = c\)]],
  " y unirla apropiadamente a la poligonal que parte de  ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " hasta llegar al valor de abscisa ",
  Cell[BoxData[
      \(TraditionalForm\`x = d\)]],
  ". Para ello dividiremos cada uno de los intervalos [c,a] y [a,d] en ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " partes de igual longitud, definiremos ",
  Cell[BoxData[
      \(TraditionalForm\`k = \((c - a)\)/n \[LessEqual] \ 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`h = \((d - a)\)/n \[GreaterEqual] \ 0\)]],
  " e iteraremos el proceso antes descrito para obtener los puntos de la \
poligonal de Euler.\na) Define un comando del tipo \
poligEuler[f,{a,b},{c,d},n,opts] que represente gr\[AAcute]ficamente en el \
intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([c, d]\)\)]],
  " la poligonal de Euler que aproxima la soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y' = f(x, y)\)]],
  " que pasa por ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  ". La variable n es el n\[UAcute]mero de divisiones que se hacen en cada \
intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([c, a]\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, d]\)\)]],
  " y determina la longitud de los lados de la poligonal, esto es, los \
valores de ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " como antes se ha indicado. Es conveniente pasarle a este comando las \
opciones de ListPlot[ ]. Sugerencia: NestList[ ] es el comando apropiado.\nb) \
Representa con \
poligEuler[f,{-1,0},2,200,PlotRange\[Rule]{{-1,1},{-.1,1.75}},AspectRatio\
\[Rule]Automatic] la aproximaci\[OAcute]n de la curva integral de la ED ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", Cell[TextData[Cell[BoxData[
              \(TraditionalForm\`y' = \(6  x\^2\)\/\(2  y\  + \ \
Cos[y]\)\)]]]]}], TraditionalForm]]],
  " que verifica la condici\[OAcute]n inicial ",
  Cell[BoxData[
      \(TraditionalForm\`y(\(-1\)) = 0\)]],
  ". \nComo se trata de una ED de variables separadas puedes indicarle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la forma de calcular su soluci\[OAcute]n general. Hazlo y calcula la \
constante que t\[UAcute] deber\[AAcute]s a\[NTilde]adir para obtener la \
soluci\[OAcute]n particular que verifica la condici\[OAcute]n inicial ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y(\(-1\))\)\(=\)\(0.\)\(\ \ \)\)\)]],
  " Representa la soluci\[OAcute]n obtenida que ser\[AAcute] de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`g(x, y) - c = 0\)]],
  ". Para eso vas a tener que usar algo como esto:"
}], "Text"],

Cell[TextData[{
  "ContourPlot[",
  Cell[BoxData[
      \(TraditionalForm\`g(x, y) - c, {x, \(-1\), 1}, {y, \(- .1\), 
        1.75}\)]],
  ",AspectRatio\[Rule]Automatic,ContourShading\[Rule]False,Contours\[Rule]1, \
Frame\[Rule]False, Axes\[Rule]True,AxesOrigin\[Rule]{0,0}]."
}], "Text"],

Cell["\<\
Compara esta gr\[AAcute]fica con la de la poligonal anterior represent\
\[AAcute]ndolas juntas (casi deben coincidir).\
\>", "Text"],

Cell[TextData[{
  "c) Considera la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y' = \(\(-\@\(1 - 2\ x + x\^2 + y\^2\)\) - x\ \@\(1 \
- 2\ x + x\^2 + y\^2\) + \@\(1 + 2\ x + x\^2 + y\^2\) - x\ \@\(1 + 2\ x + \
x\^2 + y\^2\)\)\/\(y\ \((\@\(1 - 2\ x + x\^2 + y\^2\) + \@\(1 + 2\ x + x\^2 + \
y\^2\))\)\)\)]],
  ". Representa en una misma gr\[AAcute]fica las poligonales ",
  Cell[BoxData[
      StyleBox[\(\(poligEuler[f, {\(-\@2\) +  .1,  .01}, \@2 +  .8, 
          100]\)\(\ \)\),
        FontFamily->"Times New Roman"]]],
  "y ",
  Cell[BoxData[
      StyleBox[
        RowBox[{\(poligEuler[f, {\(-\@2\) +  .1, \(- .01\)}, \@2 +  .8, 
            100]\), " ", Cell[""]}],
        FontFamily->"Times New Roman"]]],
  "(debes obtener una conocida curva). Sugerencia: Usa Show[ ] con opciones \
adecuadas."
}], "Text"],

Cell[BoxData[
    \(poligEuler[f_, {a_, b_}, {c_, d_}, n_, opts___] := 
      Module[{h = N[\((d - a)\)/n], k = N[\((c - a)\)/n], 
          siguiente}, \(siguiente[u_]\)[{x_, y_}] = {x, y} + 
            u*{1, f[x, y]}\/\@\(1 + f[x, y]^2\); \[IndentingNewLine]ListPlot[
          Join[Reverse[NestList[siguiente[k], {a, b}, n]], 
            NestList[siguiente[h], {a, b}, n]], PlotJoined \[Rule] True, 
          opts]]\)], "Input"],

Cell[BoxData[{
    \(\(f[x_, 
          y_] = \(2  x + 6  x^2\)\/\(2\ y - 3  y^2 + 4  y^3\);\)\), "\
\[IndentingNewLine]", 
    \(\(g1 = 
        Show[{poligEuler[f, {\(-1\), 1}, {\(-2\), 2}, 200, 
              PlotRange \[Rule] {{\(-1.5\), 1.5}, {\(-2\), 2}}, 
              PlotStyle \[Rule] {Hue[0], Thickness[ .03]}, 
              DisplayFunction \[Rule] Identity], 
            poligEuler[f, {\(-1\), \(- .682\)}, {\(-2\), 2}, 200, 
              PlotRange \[Rule] {{\(-1.5\), 1.5}, {\(-2\), 2}}, 
              PlotStyle \[Rule] {Hue[0], Thickness[ .03]}, 
              DisplayFunction \[Rule] Identity]}, 
          DisplayFunction \[Rule] $DisplayFunction, 
          AspectRatio \[Rule] Automatic];\)\)}], "Input"],

Cell[TextData[{
  "Las soluciones de la ED ",
  Cell[BoxData[
      StyleBox[\(y' = \(f[x, 
              y] = \(2  x + 6  x^2\)\/\(2\ y - 3  y^2 + 4  y^3\)\)\),
        FontFamily->"Times New Roman"]]],
  " se calculan inmediatamente pues se trata de la ED de variables separadas"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\((\(-2\) x - 6  x\^2)\) \[DifferentialD]x + \((2  y - 
              3  y\^2 + 4  y\^3)\) \[DifferentialD]y = 0\)]]], "Text",
  TextAlignment->Center],

Cell["cuya soluci\[OAcute]n es: ", "Text"],

Cell[BoxData[
    \(DSolve[\(y'\)[
          x] == \(2  x + 6  x^2\)\/\(2\ y[x] - 3  y[x]^2 + 4  y[x]^3\), y[x], 
      x]\)], "Input"],

Cell[BoxData[
    \(sol[x_, y_, c_] = 
      Integrate[\(-2\) x - 6  x^2, x] + 
        Integrate[2\ y - 3  y^2 + 4  y^3, y] - c\)], "Input"],

Cell[BoxData[
    \(c /. \(Solve[sol[\(-1\), 1, c] \[Equal] 0, c]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(sol[x, y, 2]\)], "Input"],

Cell[BoxData[
    \(<< Graphics`ImplicitPlot`\)], "Input"],

Cell[BoxData[
    \(\(g2 = 
        ImplicitPlot[sol[x, y, 2] \[Equal] 0, {x, \(-2\), 2}, 
          AspectRatio \[Rule] Automatic, AxesOrigin \[Rule] {0, 0}, 
          PlotPoints \[Rule] 200, 
          PlotRange \[Rule] {{\(-2\), 2}, {\(-2\), 2}}, 
          PlotStyle \[Rule] {Hue[ .6], Thickness[ .015]}];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[{g1, g2}];\)\)], "Input"],

Cell[BoxData[{
    \(\(f[x_, y_] = 
        6  x^2\/\(2  y\  + \ Cos[y]\);\)\), "\[IndentingNewLine]", 
    \(\(g1 = 
        poligEuler[f, {\(-1\), 0}, {\(-1\), 2}, 200, 
          PlotRange \[Rule] {{\(-1\), 1}, {\(- .1\), 1.75}}, 
          AspectRatio \[Rule] Automatic];\)\)}], "Input"],

Cell[BoxData[
    \(DSolve[\(y'\)[x] == 6  x^2\/\(2  y[x] + \ Cos[y[x]]\), y[x], 
      x]\)], "Input"],

Cell[BoxData[
    \(F[x_, y_, c_] = 
      Integrate[2  y\  + \ Cos[y], y] - Integrate[6\ x^2, x] - c\)], "Input"],

Cell[BoxData[
    \(c /. \(Solve[F[\(-1\), 0, c] \[Equal] 0, c]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(\(p1 = 
        ContourPlot[F[x, y, 2], {x, \(-1\), 1}, {y, \(- .1\), 1.75}, 
          AspectRatio \[Rule] Automatic, Contours \[Rule] 1, 
          ContourShading \[Rule] False, Frame \[Rule] False, 
          Axes \[Rule] True, AxesOrigin \[Rule] {0, 0}];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[{g1, p1}];\)\)], "Input"],

Cell[BoxData[{
    \(\(h[x_, 
          y_] = \(\(-\@\(1 - 2\ x + x\^2 + y\^2\)\) - x\ \@\(1 - 2\ x + x\^2 \
+ y\^2\) + \@\(1 + 2\ x + x\^2 + y\^2\) - x\ \@\(1 + 2\ x + x\^2 + y\^2\)\)\/\
\(y\ \((\@\(1 - 2\ x + x\^2 + y\^2\) + \@\(1 + 2\ x + x\^2 + \
y\^2\))\)\);\)\), "\[IndentingNewLine]", 
    \(\(Show[{poligEuler[
            h, {\(-\@2\) +  .1,  .01}, {\(-\@2\) +  .1, \@2 +  .8}, 100, 
            DisplayFunction \[Rule] Identity], 
          poligEuler[
            h, {\(-\@2\) +  .1, \(- .01\)}, {\(-\@2\) +  .1, \@2 +  .8}, 100, 
            DisplayFunction \[Rule] Identity]}, 
        AspectRatio \[Rule] Automatic, 
        DisplayFunction \[Rule] $DisplayFunction];\)\)}], "Input"],

Cell[BoxData[
    \(DSolve[\(y'\)[
            x] == \((\(-\@\(1 - 2\ x + x\^2 + y[x]\^2\)\) - 
                x\ \@\(1 - 2\ x + x\^2 + y[x]\^2\) + \@\(1 + 2\ x + x\^2 + \
y[x]\^2\) - x\ \@\(1 + 2\ x + x\^2 + y[x]\^2\))\)/\((y[
                  x]\ \((\@\(1 - 2\ x + x\^2 + y[x]\^2\) + \@\(1 + 2\ x + \
x\^2 + y[x]\^2\))\))\), y[x], x] // Simplify\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ecuaciones diferenciales exactas", "Section"],

Cell[TextData[{
  "Te recuerdo que un campo vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(F(x, y)\)\(=\)\((P(x, y), 
          Q(x, y))\)\(\ \)\)\)]],
  ", que suponemos definido en un dominio simplemente conexo del plano, es \
conservativo cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PartialD]Q\/\[PartialD]x\) \((x, 
            y)\) = \(\[PartialD]P\/\[PartialD]y\) \((x, y)\)\)]],
  " . En tal caso se verifica que hay una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`U(x, y)\)]],
  ", llamada funci\[OAcute]n potencial, \[UAcute]nica salvo constantes \
aditivas, que verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]U\/\[PartialD]x = 
        P, \ \[PartialD]U\/\[PartialD]y = Q\)]],
  " . Cuando esto es as\[IAcute], se dice que la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(P(x, y)\) \[DifferentialD]x + \ \(Q(x, 
              y)\) \[DifferentialD]y = 0\)]],
  " es exacta. La soluci\[OAcute]n general de dicha ED es la familia de \
curvas definidas impl\[IAcute]citamente por ",
  Cell[BoxData[
      \(TraditionalForm\`U(x, y) = C\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " es una constante."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "a) Define un comando que te diga si un campo vectorial de dos variables es \
o no conservativo. La sintaxis de dicho comando debe ser de la forma \
\"conservativoQ[Func]\" donde se supone que \"Func\" es el campo vectorial y \
su salida debe ser \"El campo es conservativo\" o \"El campo no es \
conservativo\". \nSugerencia. Para comprobar que dos funciones g[x,y], h[x,y] \
 son iguales es eficaz usar el comando ",
  Cell[BoxData[
      \(TraditionalForm\`Simplify[g[x, y] - h[x, y] == 0] === True\)]],
  ". El comando \"",
  Cell[BoxData[
      \(TraditionalForm\`exp1 === exp2\)]],
  "\" comprueba si las dos expresiones son ",
  StyleBox["id\[EAcute]nticas",
    FontSlant->"Italic"],
  ". La raz\[OAcute]n de esto puedes entenderla con el siguiente ejemplo."
}], "ExerciseText"],

Cell[BoxData[
    \(\(\(Simplify[x \((x + y)\) - x\^2 - x\ y == 0]\  (*\ salida\ True\ *) \n
    
    Simplify[
      x \((x + y)\) - x\^2 == 
        0] (*\ \(salida\ que\ no\ es\ True\ y ... \)\ \
\[DownExclamation]tampoco\ \(False!\)\ Por\ eso\ no\ debe\ usarse\ el\ \
comando\  \[Equal] \ 
        como\ control\ boleano\ cuando\ trabajamos\ \(simb\[OAcute]licamente \
: \ porque\ no\ es\ seguro\ que\ siempre\ sea\ False\ o\ True\)\ *) \n
    Simplify[
      x \((x + y)\) - x\^2 - x\ y === 
        0]\  (*\ \[DownExclamation]salida\ \(False!\)\ Por\ eso\ no\ se\ debe\
\ usar\  === \ 
        como\ control\ boleano\ cuando\ trabajamos\ simb\[OAcute]licamente\ *)  \
(*\ combinando\ los\ dos\ comandos\ se\ puede\ lograr\ algo\ mejor\ que\ \
parece\ que\ funciona\ bien\ *) \[IndentingNewLine]
    Simplify[x \((x + y)\) - x\^2 == 0] === True\  (*\ salida\ False, \ 
      como\ debe\ ser\ *) \n
    Simplify[x \((x + y)\) - x\^2 - x\ y == 0] === True\)\(\ \)\( (*\ 
      salida\ True, \ como\ debe\ ser\ *) \)\)\)], "Input"],

Cell["\<\
b) Define un comando que calcule simb\[OAcute]licamente una funci\[OAcute]n \
potencial de un campo vectorial conservativo de dos variables. La sintaxis \
del comando debe ser de la forma \"potencial[F][x,y]\" donde \"F\" es el \
campo. 
Sugerencia. Un comando If[ ] es suficiente. Adem\[AAcute]s, para evitar \
complicaciones, debes usar los comandos Integrate[ ]  de la forma \
Integrate[funcion[x],x] y no de la forma Integrate[funcion[x],{x,u,v}]. La \
expresi\[OAcute]n que vimos en clase para calcular la funci\[OAcute]n \
potencial puede ser \[UAcute]til.\
\>", "ExerciseText"],

Cell["\<\
c) Usa los comando definidos en los apartados anteriores para lo que sigue. \
Considera la ED\
\>", "ExerciseText"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\((3  x\ y\  + y\^2)\) \[DifferentialD]x + \((x\^2 + 
              x\ y)\) \[DifferentialD]y = 0\)]]], "ExerciseText",
  TextAlignment->Center],

Cell[TextData[{
  "\[DownQuestion]Es exacta? Comprueba que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu](x, y) = 
        1\/\(x\ y\ \((2\ x\  + \ y)\)\)\ es\ un\ factor\ integrante\ de\ \
dicha\ ED\ y\ calcula\ su\ soluci\[OAcute]n\ \(\(general\)\(.\)\)\)]],
  " Calcula la soluci\[OAcute]n particular que pasa por (1,1)."
}], "ExerciseText"],

Cell[BoxData[
    \(conservativoQ[F_] := 
      If[Simplify[
            D[\(F[x, y]\)[\([1]\)], y] - D[\(F[x, y]\)[\([2]\)], x] == 0] === 
          True, Print["\<El campo es conservativo\>"], 
        Print["\<El campo no es conservativo\>"]]\)], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_] = {6  y\  + \ y\ Exp[x\ y\ ] + 1, 
          6  x + x\ Exp[x\ y]};\)\), "\n", 
    \(conservativoQ[F]\)}], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_] = {y\^2\ Exp[x\ y\ ], x\^2\ Exp[x\ y]};\)\), "\n", 
    \(conservativoQ[F]\)}], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_] = {3\ x\ y\  + \ y^2, 
          x^2 + x\ *y};\)\), "\[IndentingNewLine]", 
    \(\(h[x_, y_] = 
        1\/\(x*\ y \((2\ x\  + y)\)\);\)\), "\[IndentingNewLine]", 
    \(conservativoQ[F]\), "\[IndentingNewLine]", 
    \(conservativoQ[F*h]\)}], "Input"],

Cell[BoxData[
    \(\(potencial[F_, ini_: {0, 0}]\)[x_, y_] := 
      Module[{u, v, temp}, 
        If[Simplify[
              D[\(F[u, v]\)[\([1]\)], v] - D[\(F[u, v]\)[\([2]\)], u] == 0] === 
            False, Print["\<El campo no es conservativo\>"], \n
          temp[{u_, v_}] = 
            Integrate[\(F[u, y]\)[\([1]\)], u] + 
              Integrate[\(F[ini[\([1]\)], v]\)[\([2]\)], v]; 
          temp[{x, y}] - temp[ini]\n\t]]\)], "Input"],

Cell[BoxData[
    \(g[x_, y_] = F[x, y]*h[x, y] // Simplify\)], "Input"],

Cell[BoxData[
    \(\(potencial[g, {1, 1}]\)[x, y]\)], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_] = {2  x\ Sin[y], \(x\^2\) Cos[y] - 3  y\^2};\)\), "\n", 
    \(\(potencial[F]\)[x, y]\), "\[IndentingNewLine]", 
    \(\(potencial[F, {1, 1}]\)[x, y]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "a) Haz un programa que calcule una soluci\[OAcute]n particular de una EDL \
con coeficientes constantes cuyo t\[EAcute]rmino independiente es de la forma \
",
  Cell[BoxData[
      \(TraditionalForm\`\(P(
          x)\) \(\[ExponentialE]\^\(\(\[Alpha]\)\(\ \)\(x\)\(\ \)\)\) \(cos(\
\[Beta]\ x)\)\)]],
  " o ",
  Cell[BoxData[
      \(TraditionalForm\`\(P(
          x)\) \(\[ExponentialE]\^\(\[Alpha]\ x\)\) \(sen(\[Beta]\ x)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`P(x)\)]],
  " es una funci\[OAcute]n polin\[OAcute]mica con coeficientes reales. \nEl \
programa debe admitir como entrada una EDL homog\[EAcute]nea y la informaci\
\[OAcute]n necesaria sobre el t\[EAcute]rmino independiente. Su sintaxis \
puede ser de la forma solParticular[edl_,coef_,{\[Alpha]_,\[Beta]_,reim_}] \
donde \"edl\" es la EDL (sin t\[EAcute]rmino independiente), \"coef\" es la \
lista ordenada de coeficientes del polinomio ",
  Cell[BoxData[
      \(TraditionalForm\`P(x)\)]],
  ", \[Alpha] y \[Beta] son los valores correspondientes y \"reim\" es una \
variable que cuando vale 1 quiere decir que hemos de elegir la \
soluci\[OAcute]n real y cuando vale 0 la imaginaria. La salida de este \
programa debe ser una soluci\[OAcute]n particular de la EDL completa \
corrrespondiente. El programa debe comprobar que la soluci\[OAcute]n obtenida \
es correcta antes de mostrarla en pantalla.\nb) Usando el programa del \
apartado anterior, calcula una soluci\[OAcute]n particular de la ED"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(32  y[x]\), "-", \(112 \( y'\)[x]\), "+", 
          RowBox[{"184", " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"180", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"80", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((4)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"68", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((5)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"174", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((6)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"179", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((7)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"112", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((8)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"44", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((9)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"10", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((10)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((11)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}], 
        "=", \(\((\(-1\) + 2  x - 3  x\^2)\)\ \(\[ExponentialE]\^x\) \(sen(
            x)\)\)}], TraditionalForm]], "ExerciseText"],

Cell[TextData[{
  "Sugerencias. Debes obtener el polinomio caracter\[IAcute]stico para \
controlar si ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + I\ \[Beta]\)]],
  " es o no ra\[IAcute]z caracter\[IAcute]stica y, en caso de serlo, obtener \
su multiplicidad. El comando Count[ ] te resuelve ese problema en una l\
\[IAcute]nea pues permite contar el n\[UAcute]mero de veces que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + I\ \[Beta]\)]],
  " figura en las ra\[IAcute]ces del polinomio caracter\[IAcute]stico. Si \
este n\[UAcute]mero es m ya puedes formar la funci\[OAcute]n auxiliar \
necesaria y hacer los c\[AAcute]culos oportunos. Finalmente, deber\[AAcute]s \
definir los dos posibles t\[EAcute]rminos independientes que pueden darse, ",
  Cell[BoxData[
      \(TraditionalForm\`\(P(
          x)\) \(\[ExponentialE]\^\(\(\[Alpha]\)\(\ \)\(x\)\(\ \)\)\) \(cos(\
\[Beta]\ x)\)\)]],
  " o ",
  Cell[BoxData[
      \(TraditionalForm\`\(P(
          x)\) \(\[ExponentialE]\^\(\[Alpha]\ x\)\) \(sen(\[Beta]\ x)\)\)]],
  ", y definir las soluciones particulares que corresponden a cada uno de \
ellos para elegir la que corresponda en cada caso (un comando Which[ ] puede \
ser \[UAcute]til)."
}], "ExerciseText"],

Cell[BoxData[
    \(solParticular[edl_, coef_, {\[Alpha]_, \[Beta]_, reim_}] := 
      Module[{policar, aux, tempcos, tempsen, coeficientes, solcos, solsen, 
          m, c, n = Length[coef]}, 
        policar[x_] = \(edl[y, x] /. \(\(Derivative[k_]\)[y]\)[x] \[Rule] 
                x\^k\) /. y[x] \[Rule] 1; \[IndentingNewLine]m = 
          Count[x /. Solve[policar[x] \[Equal] 0, x], \[Alpha] + \ 
              I\ \[Beta]]; \[IndentingNewLine]aux[x_] = 
          x^m*\((Plus @@ Table[c[k] x^k, {k, 0, n - 1}])\) 
            Exp[\((\[Alpha] + \ I\ \[Beta])\) 
                x]; \[IndentingNewLine]coeficientes = 
          CoefficientList[
            Simplify[\((Exp[\((\(-\[Alpha]\) + \ \(-I\)\ \[Beta])\) x])\) 
                edl[aux, x]], x]; \[IndentingNewLine]Evaluate[
            Table[c[k], {k, 0, n - 1}]] = 
          Table[c[k], {k, 0, n - 1}] /. \(Solve[coeficientes \[Equal] coef, 
                Table[c[k], {k, 0, 
                    n - 1}]]\)[\([1]\)]; \[IndentingNewLine]solcos[x_] = 
          ComplexExpand[Re[aux[x]]]; \[IndentingNewLine]solsen[x_] = 
          ComplexExpand[Im[aux[x]]]; \[IndentingNewLine]tempcos[
            x_] = \((coef . Table[x^k, {k, 0, n - 1}])\)*Exp[\[Alpha]\ x] 
            Cos[\[Beta]\ x]; \[IndentingNewLine]tempsen[
            x_] = \((coef . Table[x^k, {k, 0, n - 1}])\)*Exp[\[Alpha]\ x] 
            Sin[\[Beta]\ x]; \[IndentingNewLine]Which[
          reim == 1 && \ Simplify[edl[solcos, x] - tempcos[x] \[Equal] 0], 
          solcos[x], 
          reim == 0 && \ Simplify[edl[solsen, x] - tempsen[x] \[Equal] 0], 
          solsen[x]]\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(edl[y_, x_]\), "=", 
        RowBox[{\(32  y[x]\), "-", \(112 \( y'\)[x]\), "+", 
          RowBox[{"184", " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"180", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"80", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((4)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"68", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((5)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"174", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((6)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"179", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((7)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"112", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((8)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"44", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((9)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"10", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((10)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((11)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}]}], ";"}]], "Input"],

Cell[BoxData[{
    \(h[x_] = 
      solParticular[
        edl, {\(-1\), 2, \(-3\)}, {1, 1, 0}]\), "\[IndentingNewLine]", 
    \(edl[h, x] // Simplify\)}], "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 47, 0, 99, "Title"],

Cell[CellGroupData[{
Cell[1826, 55, 31, 0, 68, "Exercise"],
Cell[1860, 57, 357, 6, 93, "ExerciseText"],
Cell[2220, 65, 185, 5, 55, "NumberedEquation"],
Cell[2408, 72, 1500, 44, 255, "ExerciseText"],
Cell[3911, 118, 70, 1, 72, "Input"],
Cell[3984, 121, 450, 8, 220, "Input"],
Cell[4437, 131, 176, 4, 119, "Input"],
Cell[4616, 137, 122, 2, 72, "Input"],
Cell[4741, 141, 86, 1, 72, "Input"],
Cell[4830, 144, 58, 1, 72, "Input"],
Cell[4891, 147, 197, 4, 124, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5125, 156, 31, 0, 68, "Exercise"],
Cell[5159, 158, 574, 11, 108, "NumberedEquation"],
Cell[5736, 171, 3109, 86, 471, "ExerciseText"],
Cell[8848, 259, 415, 7, 208, "Input"],
Cell[9266, 268, 449, 8, 208, "Input"],
Cell[9718, 278, 176, 3, 138, "Input"],
Cell[9897, 283, 83, 1, 72, "Input"],
Cell[9983, 286, 69, 1, 72, "Input"],
Cell[10055, 289, 135, 2, 127, "Input"],
Cell[10193, 293, 130, 2, 127, "Input"],
Cell[10326, 297, 153, 2, 72, "Input"],
Cell[10482, 301, 153, 2, 94, "Input"],
Cell[10638, 305, 153, 2, 94, "Input"],
Cell[10794, 309, 109, 2, 120, "Input"],
Cell[10906, 313, 529, 9, 250, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11472, 327, 31, 0, 68, "Exercise"],
Cell[11506, 329, 1594, 41, 307, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13137, 375, 39, 0, 93, "Section"],
Cell[13179, 377, 625, 14, 119, "Text"],
Cell[13807, 393, 669, 16, 89, "Text"],
Cell[14479, 411, 4188, 108, 514, "Text"],
Cell[18670, 521, 289, 7, 67, "Text"],
Cell[18962, 530, 142, 3, 41, "Text"],
Cell[19107, 535, 819, 20, 128, "Text"],
Cell[19929, 557, 434, 7, 245, "Input"],
Cell[20366, 566, 726, 14, 279, "Input"],
Cell[21095, 582, 293, 7, 49, "Text"],
Cell[21391, 591, 202, 3, 36, "Text"],
Cell[21596, 596, 42, 0, 41, "Text"],
Cell[21641, 598, 135, 3, 98, "Input"],
Cell[21779, 603, 141, 3, 94, "Input"],
Cell[21923, 608, 89, 1, 94, "Input"],
Cell[22015, 611, 45, 1, 94, "Input"],
Cell[22063, 614, 58, 1, 94, "Input"],
Cell[22124, 617, 325, 6, 146, "Input"],
Cell[22452, 625, 52, 1, 94, "Input"],
Cell[22507, 628, 291, 6, 153, "Input"],
Cell[22801, 636, 103, 2, 98, "Input"],
Cell[22907, 640, 114, 2, 72, "Input"],
Cell[23024, 644, 87, 1, 72, "Input"],
Cell[23114, 647, 293, 5, 124, "Input"],
Cell[23410, 654, 52, 1, 72, "Input"],
Cell[23465, 657, 697, 13, 317, "Input"],
Cell[24165, 672, 362, 6, 235, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24564, 683, 51, 0, 93, "Section"],
Cell[24618, 685, 1204, 30, 161, "Text"],

Cell[CellGroupData[{
Cell[25847, 719, 31, 0, 68, "Exercise"],
Cell[25881, 721, 804, 16, 179, "ExerciseText"],
Cell[26688, 739, 1033, 20, 385, "Input"],
Cell[27724, 761, 594, 10, 153, "ExerciseText"],
Cell[28321, 773, 125, 3, 41, "ExerciseText"],
Cell[28449, 778, 195, 3, 36, "ExerciseText"],
Cell[28647, 783, 347, 7, 75, "ExerciseText"],
Cell[28997, 792, 258, 5, 124, "Input"],
Cell[29258, 799, 148, 3, 98, "Input"],
Cell[29409, 804, 121, 2, 99, "Input"],
Cell[29533, 808, 286, 6, 182, "Input"],
Cell[29822, 816, 451, 9, 228, "Input"],
Cell[30276, 827, 72, 1, 72, "Input"],
Cell[30351, 830, 63, 1, 72, "Input"],
Cell[30417, 833, 196, 3, 125, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30650, 841, 31, 0, 68, "Exercise"],
Cell[30684, 843, 1528, 30, 291, "ExerciseText"],
Cell[32215, 875, 2313, 62, 66, "ExerciseText"],
Cell[34531, 939, 1234, 25, 171, "ExerciseText"],
Cell[35768, 966, 1641, 27, 510, "Input"],
Cell[37412, 995, 2220, 60, 147, "Input"],
Cell[39635, 1057, 164, 4, 98, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

